<?php
/*phptext class, version 1.0
created by www.w3schools.in (Gautam kumar)
April 26, 2014

Modified June 2016 by MD-Technologie -> www.md-technologie.de 
*/  
class phptextClass
{	
	public function phptext($text,$textColor,$backgroundColor='',$fontSize,$imgWidth,$imgHeight,$dir,$fileName)
	{
		/* settings */
		$font = './calibri.ttf';/*define font*/
		$textColor=$this->hexToRGB($textColor);	
		
		$im = imagecreatetruecolor($imgWidth, $imgHeight);	
		$textColor = imagecolorallocate($im, $textColor['r'],$textColor['g'],$textColor['b']);	
		
		if($backgroundColor==''){/*select random color*/
			$colorCode=array('#56aad8', '#61c4a8', '#d3ab92');
			$backgroundColor = $this->hexToRGB($colorCode[rand(0, count($colorCode)-1)]);
			$backgroundColor = imagecolorallocate($im, $backgroundColor['r'],$backgroundColor['g'],$backgroundColor['b']);
		}else{/*select background color as provided*/
			$backgroundColor = $this->hexToRGB($backgroundColor);
			$backgroundColor = imagecolorallocate($im, $backgroundColor['r'],$backgroundColor['g'],$backgroundColor['b']);
		}
		
		imagefill($im,0,0,$backgroundColor);	
		list($x, $y) = $this->ImageTTFCenter($im, $text, $font, $fontSize);	
		imagettftext($im, $fontSize, 0, $x, $y, $textColor, $font, $text);
		if(imagejpeg($im,$dir.$fileName,90)){/*save image as JPG*/
			return json_encode(array('status'=>TRUE,'image'=>$dir.$fileName));
		imagedestroy($im);	
		}
	}	
	
	public function phpcaptcha($textColor,$backgroundColor,$imgWidth,$imgHeight=60,$noiceLines=0,$noiceDots=0,$noiceColor='#162453')
	{	
		/* Settings */
		//$text=$this->random();
		if(!empty($_GET['captcha_code'])) $text = urldecode($_GET['captcha_code']);
		if(empty($_GET['captcha_code'])) $text = "ERROR";
    $font = './../assets/font/monofont.ttf';/* font */
		$textColor=$this->hexToRGB($textColor);	
		$fontSize = $imgHeight * 0.75;
		$imgWidth = strlen($text) * 20+20;
		
		$noiceLines = $noiceLines*ceil(strlen($text)/2);
		$noiceDots = $noiceDots*strlen($text);
		
		//$im = imagecreatetruecolor($imgWidth, $imgHeight);
		$im = imagecreate ($imgWidth, $imgHeight);

    	
		$textColor = ImageColorAllocate($im, $textColor['r'],$textColor['g'],$textColor['b']);			
		
		$backgroundColor = $this->hexToRGB($backgroundColor);
		$backgroundColor = ImageColorAllocate($im, $backgroundColor['r'],$backgroundColor['g'],$backgroundColor['b']);

		imagefill($im,0,0,$backgroundColor);	
				
		/* generating lines randomly in background of image */
		if($noiceLines>0){
		$noiceColor=$this->hexToRGB($noiceColor);	
		$noiceColor = imagecolorallocate($im, $noiceColor['r'],$noiceColor['g'],$noiceColor['b']);
		for( $i=0; $i<$noiceLines; $i++ ) {				
			imageline($im, mt_rand(0,$imgWidth), mt_rand(0,$imgHeight),
			mt_rand(0,$imgWidth), mt_rand(0,$imgHeight), $noiceColor);
		}}
    				
    // generating the dots randomly in background
		if($noiceDots>0){
		for( $i=0; $i<$noiceDots; $i++ ) {
			imagefilledellipse($im, mt_rand(0,$imgWidth),
			mt_rand(0,$imgHeight), 3, 3, $textColor);
		}}		
		
		
	 list($x, $y) = $this->ImageTTFCenter($im, $text, $font, $fontSize);	
	 //ImageTTFText($im, $fontSize, 0, $x, $y, $textColor, $font, $text);
   $x=ceil($x/2);
    $x=0;
    for($i=0; $i<strlen($text); $i++)
    {      
      $x=$x+18;
      $angle = mt_rand(0, 40)-20;
      $y1=mt_rand($y-3,$y+3);		
  		imagettftext($im, $fontSize, $angle, $x, $y1, $textColor, $font, $text[$i]);		      
    }
    

    Header ("Content-type: image/jpeg");


		imagejpeg($im,NULL, 50);/* Showing image */
    //header('Content-Disposition: Attachment;filename=PasswordImage.jpeg'); 
		//header('Content-Type: image/jpeg');/* defining the image type to be shown in browser widow */

		
		ImageDestroy($im);/* Destroying image instance */
		//if(isset($_SESSION)){
		//	$_SESSION['captcha_code'] = $text;/* set random text in session for captcha validation*/
		//}
		return "models/password.jpg";
	}
	
	/*for random string*/
	protected function random($characters=6,$letters = '23456789bcdfghjkmnpqrstvwxyz'){

		$str='';
		for ($i=0; $i<$characters; $i++) { 
			$str .= substr($letters, mt_rand(0, strlen($letters)-1), 1);
		}
		return $str;
	}	
	
	/*function to convert hex value to rgb array*/
	protected function hexToRGB($colour)
	{
			if ( $colour[0] == '#' ) {
					$colour = substr( $colour, 1 );
			}
			if ( strlen( $colour ) == 6 ) {
					list( $r, $g, $b ) = array( $colour[0] . $colour[1], $colour[2] . $colour[3], $colour[4] . $colour[5] );
			} elseif ( strlen( $colour ) == 3 ) {
					list( $r, $g, $b ) = array( $colour[0] . $colour[0], $colour[1] . $colour[1], $colour[2] . $colour[2] );
			} else {
					return false;
			}
			$r = hexdec( $r );
			$g = hexdec( $g );
			$b = hexdec( $b );
			return array( 'r' => $r, 'g' => $g, 'b' => $b );
	}		
		
	/*function to get center position on image*/
	protected function ImageTTFCenter($image, $text, $font, $size, $angle = 8) 
	{
		$xi = imagesx($image);
		$yi = imagesy($image);
		$box = imagettfbbox($size, $angle, $font, $text);
		$xr = abs(max($box[2], $box[4]));
		$yr = abs(max($box[5], $box[7]));
		$x = intval(($xi - $xr) / 2);
		$y = intval(($yi + $yr) / 2);
		return array($x, $y);	
	}
}
?>